/*
 * Decompiled with CFR 0.152.
 */
package elements;

import base.Outil;
import divers.FiltreCSV;
import elements.Participant;
import exceptions.AnnulationException;
import filtre.Filtre;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import ressources.CSV;
import ressources.Fichiers;

public abstract class Ensemble
extends DefaultListModel
implements TableModel {
    private static final long serialVersionUID = 1L;
    public static final String[] SEXE = new String[]{"Sexe", "Genre"};
    public static final String[] GROUPE = new String[]{"Groupe", "Classe", "Cat\u00e9gorie"};
    public static final String[] CLASSEMENT = new String[]{"Classement", "Place"};
    public static final String[] TEMPS = new String[]{"Temps"};
    public static final String[] DOSSARD = new String[]{"Dossard", "ID", "no", "no dossard"};
    private List<Participant> liste;
    private List<String> colonnes;
    private final String nom;

    public Ensemble(String nom, List<String> colonnes, List<Participant> liste) {
        this.nom = nom;
        this.colonnes = colonnes;
        this.liste = liste;
    }

    public Ensemble(String nom) {
        this(nom, new ArrayList<String>(), new ArrayList<Participant>());
    }

    public Ensemble(File f) {
        this(f.getName().split(".csv")[0]);
        boolean col = false;
        for (List<String> l : CSV.lire(Fichiers.lire(f))) {
            if (!col) {
                this.colonnes = l;
                col = true;
                continue;
            }
            Participant p = this.getParticipantFichier(l);
            if (p.estVide()) continue;
            this.liste.add(p);
        }
        if (this.colonnes == null) {
            this.colonnes = new ArrayList<String>();
        }
    }

    public abstract String getPath();

    public abstract Participant getParticipantFichier(List<String> var1);

    public void setColonnes(List<String> colonnes) {
        this.colonnes = colonnes;
    }

    public void filtrer(List<Participant> liste, Iterable<Filtre> filtres) {
        ArrayList<Participant> nouveau = new ArrayList<Participant>();
        this.liste = liste;
        int i = 0;
        while (i < liste.size()) {
            boolean ok = true;
            for (Filtre f : filtres) {
                if (f.accepte(this, i)) continue;
                ok = false;
                break;
            }
            if (ok) {
                nouveau.add(liste.get(i));
            }
            ++i;
        }
        this.liste = nouveau;
        this.change();
    }

    public List<String> getCSV() {
        ArrayList<String> l = new ArrayList<String>(this.liste.size());
        ArrayList<String> colonnes = new ArrayList<String>();
        int j = 0;
        while (j < this.getColumnCount()) {
            colonnes.add(this.getColumnName(j));
            ++j;
        }
        l.add(CSV.separer(colonnes));
        int i = 0;
        while (i < this.getRowCount()) {
            ArrayList<String> ligne = new ArrayList<String>();
            int j2 = 0;
            while (j2 < this.getColumnCount()) {
                ligne.add("" + this.getValueAt(i, j2));
                ++j2;
            }
            l.add(CSV.separer(ligne));
            ++i;
        }
        return l;
    }

    public void exporter() throws AnnulationException, FileNotFoundException {
        this.enregistrer(Outil.getFichier("Enregistrer", new FiltreCSV()));
    }

    public void enregister() throws FileNotFoundException {
        this.enregistrer(this.getFichier());
    }

    public File getFichier() {
        return Fichiers.getFichier(String.valueOf(this.getPath()) + this.nom + ".csv", true);
    }

    public void enregistrer(File f) throws FileNotFoundException {
        if (!f.getName().endsWith(".csv")) {
            f = new File(String.valueOf(f.getAbsolutePath()) + ".csv");
        }
        Fichiers.ecrire(new FileOutputStream(f), this.getCSV());
    }

    public void supprimer() {
        Fichiers.supprimer(this.getFichier());
    }

    public boolean existe() {
        return Fichiers.existe(String.valueOf(this.getPath()) + this.nom + ".csv");
    }

    public int getIndexColonneListe(String ... noms) throws AnnulationException {
        int i = 0;
        while (i < this.colonnes.size()) {
            String[] stringArray = noms;
            int n = noms.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equalsIgnoreCase(this.colonnes.get(i))) {
                    return i;
                }
                ++n2;
            }
            ++i;
        }
        throw new AnnulationException("Impossible de d\u00e9tecter cette colonne");
    }

    public int getIndexColonne(String ... noms) throws AnnulationException {
        int i = 0;
        while (i < this.getColumnCount()) {
            String[] stringArray = noms;
            int n = noms.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equalsIgnoreCase(this.getColumnName(i))) {
                    return i;
                }
                ++n2;
            }
            ++i;
        }
        throw new AnnulationException("Impossible de d\u00e9tecter cette colonne");
    }

    public void change() {
        TableModelEvent e = new TableModelEvent(this);
        TableModelListener[] tableModelListenerArray = (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
        int n = tableModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableModelListener l = tableModelListenerArray[n2];
            l.tableChanged(e);
            ++n2;
        }
        ListDataEvent d = new ListDataEvent(this, 0, 0, this.liste.size());
        ListDataListener[] listDataListenerArray = this.getListDataListeners();
        int n3 = listDataListenerArray.length;
        n = 0;
        while (n < n3) {
            ListDataListener l = listDataListenerArray[n];
            l.contentsChanged(d);
            ++n;
        }
    }

    public void ajout(Participant e) {
        this.liste.add(e);
        this.change();
    }

    public void supprime(Participant e) {
        int i = 0;
        while (i < this.liste.size()) {
            if (this.liste.get(i).equivalent(e)) {
                this.liste.remove(i);
                --i;
            }
            ++i;
        }
        this.change();
    }

    public int getIndexSexe() throws AnnulationException {
        return this.getIndexColonne(SEXE);
    }

    public int getIndexGroupe() throws AnnulationException {
        return this.getIndexColonne(GROUPE);
    }

    public int getIndexClassement() throws AnnulationException {
        return this.getIndexColonne(CLASSEMENT);
    }

    public int getIndexTemps() throws AnnulationException {
        return this.getIndexColonne(TEMPS);
    }

    public List<String> getColonnes() {
        return this.colonnes;
    }

    public List<Participant> getListe() {
        return this.liste;
    }

    public String getNom() {
        return this.nom;
    }

    public boolean contient(Participant p) {
        for (Participant pa : this.liste) {
            if (!pa.equivalent(p)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return String.class;
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    @Override
    public int getColumnCount() {
        return this.colonnes.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.colonnes.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.liste.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.liste.get(rowIndex).getChamp(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.liste.get(rowIndex).setChamp(columnIndex, aValue);
    }

    @Override
    public Object getElementAt(int i) {
        return this.liste.get(i);
    }

    @Override
    public int getSize() {
        return this.liste.size();
    }
}

